/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <xfGraph_utils.h>
#include <..\Originlab\okThemeID.h>

////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.

void PlotSelDataRangeAndChangeStyle()
{
	Worksheet wks;   //Get the active Worksheet
	
	wks.Create();
	int nSize = wks.GetNumRows();           //Get the current Worksheet column numbers
	vector vX, vY;
	
	XYRange dr;								//set the XYRange
	dr.Add(wks, 0, "X");                   
	dr.Add(wks, 1, "Y");
	
	for (int i = 0; i < nSize; i++)			//Generate random data vector
    {
           double rr = rnd();
           vX.Add(rr);
           
           rr = rnd();
           vY.Add(rr);
    }
    
    vX.Sort(SORT_ASCENDING);				//sort the vector data x, y 
    vY.Sort(SORT_ASCENDING);
    
    dr.SetData(&vY, &vX);					//put the vector vX, vY, to XYRange dr
    
    
  	GraphPage gp;							//create new graph page							
    gp.Create();
    
    GraphLayer gl;							//create new layer on the page
    gl = gp.Layers(0);
    
    int nIndex = 0;
    DataPlot dp = dr.MakePlot(gl,NULL, nIndex);		//make plot by the XYRange;
    gl.Rescale();
    
  
	Tree tr;
	tr = dp.GetFormat(FPB_ALL, FOB_ALL,true, true);
	
	//change the line width just for fun
	TreeNode trLineWidth = tree_get_node_by_nodeid(tr, OTID_CURVE_LINE_WIDTH, 3);
	if(trLineWidth)
		trLineWidth.dVal = 5;
	
	//change the line color just for fun
	TreeNode trLineColor = tree_get_node_by_nodeid(tr, OTID_CURVE_LINE_COLOR, 3);
	if(trLineColor)
		trLineColor.nVal = 3; //green 
	
	dp.ApplyFormat(tr, true, true);	//apply format
}